@extends("layaout.plantilla")
@section("titulo")
Segettm - Servicios
@endsection
@section("menu")
<li><a href="{{ route("inicio") }}">Inicio</a></li>
          <li><a href="{{ route("nosotros") }}">Nosotros</a></li>
          <li><a href="{{ route("servicios") }}" class="active">Servicios</a></li>
          <li><a href="{{ route("contactanos") }}">Contactanos</a></li>
@endsection
@section("pagina")
<main id="main">

    <!-- ======= Breadcrumbs ======= -->
    <div class="breadcrumbs">
      <div class="page-header d-flex align-items-center" style="background-image: url('assets/img/page-header.jpg');">
        <div class="container position-relative">
          <div class="row d-flex justify-content-center">
            <div class="col-lg-6 text-center">
              <h2>Servicios</h2>
              <p>En SEGETTM, C.A, nos sentimos fielmente
                comprometidos con el crecimiento de la economía y la
                producción nacional, por lo que proporcionamos un
                servicio oportuno y eficiente.</p>
            </div>
          </div>
        </div>
      </div>
      <nav>
        <div class="container">
          <ol>
            <li><a href="{{ route("inicio") }}">Inicio</a></li>
            <li>Servicios</li>
          </ol>
        </div>
      </nav>
    </div><!-- End Breadcrumbs -->

    <!-- ======= Featured Services Section ======= -->
    <section id="featured-services" class="featured-services">
        <div class="container">

          <div class="row gy-4">

            <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up">
              <div class="icon flex-shrink-0"><i class="fa-solid fa-truck"></i></div>
              <div>
                <h4 class="title">Traslados Terrestres</h4>
                <p class="description">Voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident</p>
              </div>
            </div>
            <!-- End Service Item -->

            <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up" data-aos-delay="100">
              <div class="icon flex-shrink-0"><i class="fa-solid fa-ship"></i></div>
              <div>
                <h4 class="title">Traslados Marítimos</h4>
                <p class="description">Minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat tarad limino ata</p>

              </div>
            </div><!-- End Service Item -->

            <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up" data-aos-delay="200">
              <div class="icon flex-shrink-0"><i class="fa-solid fa-truck-ramp-box"></i></div>
              <div>
                <h4 class="title">Logistica</h4>
                <p class="description">Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur</p>

              </div>
            </div><!-- End Service Item -->

          </div>

        </div>
      </section><!-- End Featured Services Section -->


    <!-- ======= Services Section ======= -->
    <section id="service" class="services pt-0">
        <div class="container" data-aos="fade-up">

          <div class="section-header">
            <span>Nuestros Servicios</span>
            <h2>Nuestros Servicios</h2>

          </div>

          <div class="row gy-4">

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
              <div class="card">
                <div class="card-img">
                  <img src="assets/img/storage-service.jpg" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Storage</a></h3>
                <p>Cumque eos in qui numquam. Aut aspernatur perferendis sed atque quia voluptas quisquam repellendus temporibus itaqueofficiis odit</p>
              </div>
            </div><!-- End Card Item -->

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
              <div class="card">
                <div class="card-img">
                  <img src="assets/img/logistics-service.jpg" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Logistics</a></h3>
                <p>Asperiores provident dolor accusamus pariatur dolore nam id audantium ut et iure incidunt molestiae dolor ipsam ducimus occaecati nisi</p>
              </div>
            </div><!-- End Card Item -->

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
              <div class="card">
                <div class="card-img">
                  <img src="assets/img/cargo-service.jpg" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Cargo</a></h3>
                <p>Dicta quam similique quia architecto eos nisi aut ratione aut ipsum reiciendis sit doloremque oluptatem aut et molestiae ut et nihil</p>
              </div>
            </div><!-- End Card Item -->

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="400">
              <div class="card">
                <div class="card-img">
                  <img src="assets/img/trucking-service.jpg" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Trucking</a></h3>
                <p>Dicta quam similique quia architecto eos nisi aut ratione aut ipsum reiciendis sit doloremque oluptatem aut et molestiae ut et nihil</p>
              </div>
            </div><!-- End Card Item -->

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="500">
              <div class="card">
                <div class="card-img">
                  <img src="assets/img/packaging-service.jpg" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Packaging</a></h3>
                <p>Illo consequuntur quisquam delectus praesentium modi dignissimos facere vel cum onsequuntur maiores beatae consequatur magni voluptates</p>
              </div>
            </div><!-- End Card Item -->

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="600">
              <div class="card">
                <div class="card-img">
                  <img src="assets/img/warehousing-service.jpg" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Warehousing</a></h3>
                <p>Quas assumenda non occaecati molestiae. In aut earum sed natus eatae in vero. Ab modi quisquam aut nostrum unde et qui est non quo nulla</p>
              </div>
            </div><!-- End Card Item -->

          </div>

        </div>
      </section><!-- End Services Section -->



      <!-- ======= Features Section ======= -->
    <section id="features" class="features">
        <div class="container " data-aos="fade-up">
          <div class="section-header">
              <span>Valores Corporativos</span>
              <h2>Valores Corporativos</h2>

            </div>
          <div class="row gy-4 align-items-center features-item" data-aos="fade-up">

            <div class="col-md-5">
              <img src="assets/img/features-1.jpg" class="img-fluid" alt="">
            </div>
            <div class="col-md-7">
              <h3>1.	Responsabilidad</h3>
              <p class="fst-italic">
                  Somos fieles cumplidores de nuestras obligaciones.
              </p>
              <p>
                  Nos enfocamos en
                  brindar soluciones y una repuesta inmediata a
                  nuestros clientes.

              </p>
            </div>
          </div><!-- Features Item -->

          <div class="row gy-4 align-items-center features-item" data-aos="fade-up">
            <div class="col-md-5 order-1 order-md-2">
              <img src="assets/img/features-2.jpg" class="img-fluid" alt="">
            </div>
            <div class="col-md-7 order-2 order-md-1">
              <h3>2.	Compromiso</h3>
              <p class="fst-italic">
                  Aplicado en el cumplimiento de nuestros servicios.
              </p>
              <p>
                  En SEGETTM nos esmeramos por ser
                  una empresa enfocados en la excelencia,
                  brindando un servicio confiable y seguro,
                  sencillamente porque nuestros clientes
                  son la prioridad.
              </p>
            </div>
          </div><!-- Features Item -->

          <div class="row gy-4 align-items-center features-item" data-aos="fade-up">
            <div class="col-md-5">
              <img src="assets/img/features-3.jpg" class="img-fluid" alt="">
            </div>
            <div class="col-md-7">
              <h3>3.	Dedicación</h3>
              <p  class="fst-italic">Nos esforzamos en brindar a nuestros clientes el mejor servicio.</p>
              <p>
                  La calidad es un objetivo permanente en todos los servicios llevados a cabo en la organización, con el propósito de asegurar la satisfacción, atención oportuna, servicio confiable, seguro y con la disposición de un personal competente
              </p>
            </div>
          </div><!-- Features Item -->

          <div class="row gy-4 align-items-center features-item" data-aos="fade-up">
            <div class="col-md-5 order-1 order-md-2">
              <img src="assets/img/features-4.jpg" class="img-fluid" alt="">
            </div>
            <div class="col-md-7 order-2 order-md-1">
              <h3>4.	Perseverancia</h3>
              <p class="fst-italic">
                  Nos mantenemos insistiendo en nuestro propósito.
              </p>
              <p>
                  Actualmente SEGETTM, C.A. cuenta con 6 años de experiencia en el mercado
                  nacional, prestándole sus servicios a empresas del sector público y privado
                  venezolano
              </p>
            </div>
          </div><!-- Features Item -->

          <div class="row gy-4 align-items-center features-item" data-aos="fade-up">
              <div class="col-md-5">
                <img src="assets/img/features-3.jpg" class="img-fluid" alt="">
              </div>
              <div class="col-md-7">
                  <h3>5.  Optimismo</h3>
                  <p class="fst-italic">
                    Mantenemos una actitud positiva en nuestro día a día.
                  </p>
                  <p>
                    Garantizando la operación, el cumplimiento con los requisitos, necesidades y expectativas de nuestros clientes y partes interesadas, con una dirección estratégica que contempla el análisis permanente del contexto y compromiso con la mejora continua del Sistema de Gestión de Calidad.
                  </p>
              </div>
            </div><!-- Features Item -->


        </div>
      </section><!-- End Features Section -->

    <!-- ======= Testimonials Section ======= -->
    <section id="testimonials" class="testimonials">
      <div class="container">

        <div class="slides-1 swiper" data-aos="fade-up">
          <div class="swiper-wrapper">

            <div class="swiper-slide">
              <div class="testimonial-item">
                <img src="assets/img/testimonials/testimonials-1.jpg" class="testimonial-img" alt="">
                <h3>Saul Goodman</h3>
                <h4>Ceo &amp; Founder</h4>
                <div class="stars">
                  <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
                </div>
                <p>
                  <i class="bi bi-quote quote-icon-left"></i>
                  Proin iaculis purus consequat sem cure digni ssim donec porttitora entum suscipit rhoncus. Accusantium quam, ultricies eget id, aliquam eget nibh et. Maecen aliquam, risus at semper.
                  <i class="bi bi-quote quote-icon-right"></i>
                </p>
              </div>
            </div><!-- End testimonial item -->

            <div class="swiper-slide">
              <div class="testimonial-item">
                <img src="assets/img/testimonials/testimonials-2.jpg" class="testimonial-img" alt="">
                <h3>Sara Wilsson</h3>
                <h4>Designer</h4>
                <div class="stars">
                  <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
                </div>
                <p>
                  <i class="bi bi-quote quote-icon-left"></i>
                  Export tempor illum tamen malis malis eram quae irure esse labore quem cillum quid cillum eram malis quorum velit fore eram velit sunt aliqua noster fugiat irure amet legam anim culpa.
                  <i class="bi bi-quote quote-icon-right"></i>
                </p>
              </div>
            </div><!-- End testimonial item -->

            <div class="swiper-slide">
              <div class="testimonial-item">
                <img src="assets/img/testimonials/testimonials-3.jpg" class="testimonial-img" alt="">
                <h3>Jena Karlis</h3>
                <h4>Store Owner</h4>
                <div class="stars">
                  <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
                </div>
                <p>
                  <i class="bi bi-quote quote-icon-left"></i>
                  Enim nisi quem export duis labore cillum quae magna enim sint quorum nulla quem veniam duis minim tempor labore quem eram duis noster aute amet eram fore quis sint minim.
                  <i class="bi bi-quote quote-icon-right"></i>
                </p>
              </div>
            </div><!-- End testimonial item -->

            <div class="swiper-slide">
              <div class="testimonial-item">
                <img src="assets/img/testimonials/testimonials-4.jpg" class="testimonial-img" alt="">
                <h3>Matt Brandon</h3>
                <h4>Freelancer</h4>
                <div class="stars">
                  <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
                </div>
                <p>
                  <i class="bi bi-quote quote-icon-left"></i>
                  Fugiat enim eram quae cillum dolore dolor amet nulla culpa multos export minim fugiat minim velit minim dolor enim duis veniam ipsum anim magna sunt elit fore quem dolore labore illum veniam.
                  <i class="bi bi-quote quote-icon-right"></i>
                </p>
              </div>
            </div><!-- End testimonial item -->

            <div class="swiper-slide">
              <div class="testimonial-item">
                <img src="assets/img/testimonials/testimonials-5.jpg" class="testimonial-img" alt="">
                <h3>John Larson</h3>
                <h4>Entrepreneur</h4>
                <div class="stars">
                  <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
                </div>
                <p>
                  <i class="bi bi-quote quote-icon-left"></i>
                  Quis quorum aliqua sint quem legam fore sunt eram irure aliqua veniam tempor noster veniam enim culpa labore duis sunt culpa nulla illum cillum fugiat legam esse veniam culpa fore nisi cillum quid.
                  <i class="bi bi-quote quote-icon-right"></i>
                </p>
              </div>
            </div><!-- End testimonial item -->

          </div>
          <div class="swiper-pagination"></div>
        </div>

      </div>
    </section><!-- End Testimonials Section -->

    <!-- ======= Frequently Asked Questions Section ======= -->
    <section id="faq" class="faq">
      <div class="container" data-aos="fade-up">

        <div class="section-header">
          <span>Frequently Asked Questions</span>
          <h2>Frequently Asked Questions</h2>

        </div>

        <div class="row justify-content-center" data-aos="fade-up" data-aos-delay="200">
          <div class="col-lg-10">

            <div class="accordion accordion-flush" id="faqlist">

              <div class="accordion-item">
                <h3 class="accordion-header">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-content-1">
                    <i class="bi bi-question-circle question-icon"></i>
                    Non consectetur a erat nam at lectus urna duis?
                  </button>
                </h3>
                <div id="faq-content-1" class="accordion-collapse collapse" data-bs-parent="#faqlist">
                  <div class="accordion-body">
                    Feugiat pretium nibh ipsum consequat. Tempus iaculis urna id volutpat lacus laoreet non curabitur gravida. Venenatis lectus magna fringilla urna porttitor rhoncus dolor purus non.
                  </div>
                </div>
              </div><!-- # Faq item-->

              <div class="accordion-item">
                <h3 class="accordion-header">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-content-2">
                    <i class="bi bi-question-circle question-icon"></i>
                    Feugiat scelerisque varius morbi enim nunc faucibus a pellentesque?
                  </button>
                </h3>
                <div id="faq-content-2" class="accordion-collapse collapse" data-bs-parent="#faqlist">
                  <div class="accordion-body">
                    Dolor sit amet consectetur adipiscing elit pellentesque habitant morbi. Id interdum velit laoreet id donec ultrices. Fringilla phasellus faucibus scelerisque eleifend donec pretium. Est pellentesque elit ullamcorper dignissim. Mauris ultrices eros in cursus turpis massa tincidunt dui.
                  </div>
                </div>
              </div><!-- # Faq item-->

              <div class="accordion-item">
                <h3 class="accordion-header">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-content-3">
                    <i class="bi bi-question-circle question-icon"></i>
                    Dolor sit amet consectetur adipiscing elit pellentesque habitant morbi?
                  </button>
                </h3>
                <div id="faq-content-3" class="accordion-collapse collapse" data-bs-parent="#faqlist">
                  <div class="accordion-body">
                    Eleifend mi in nulla posuere sollicitudin aliquam ultrices sagittis orci. Faucibus pulvinar elementum integer enim. Sem nulla pharetra diam sit amet nisl suscipit. Rutrum tellus pellentesque eu tincidunt. Lectus urna duis convallis convallis tellus. Urna molestie at elementum eu facilisis sed odio morbi quis
                  </div>
                </div>
              </div><!-- # Faq item-->

              <div class="accordion-item">
                <h3 class="accordion-header">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-content-4">
                    <i class="bi bi-question-circle question-icon"></i>
                    Ac odio tempor orci dapibus. Aliquam eleifend mi in nulla?
                  </button>
                </h3>
                <div id="faq-content-4" class="accordion-collapse collapse" data-bs-parent="#faqlist">
                  <div class="accordion-body">
                    <i class="bi bi-question-circle question-icon"></i>
                    Dolor sit amet consectetur adipiscing elit pellentesque habitant morbi. Id interdum velit laoreet id donec ultrices. Fringilla phasellus faucibus scelerisque eleifend donec pretium. Est pellentesque elit ullamcorper dignissim. Mauris ultrices eros in cursus turpis massa tincidunt dui.
                  </div>
                </div>
              </div><!-- # Faq item-->

              <div class="accordion-item">
                <h3 class="accordion-header">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-content-5">
                    <i class="bi bi-question-circle question-icon"></i>
                    Tempus quam pellentesque nec nam aliquam sem et tortor consequat?
                  </button>
                </h3>
                <div id="faq-content-5" class="accordion-collapse collapse" data-bs-parent="#faqlist">
                  <div class="accordion-body">
                    Molestie a iaculis at erat pellentesque adipiscing commodo. Dignissim suspendisse in est ante in. Nunc vel risus commodo viverra maecenas accumsan. Sit amet nisl suscipit adipiscing bibendum est. Purus gravida quis blandit turpis cursus in
                  </div>
                </div>
              </div><!-- # Faq item-->

            </div>

          </div>
        </div>

      </div>
    </section><!-- End Frequently Asked Questions Section -->

  </main><!-- End #main -->
@endsection
