@extends("layaout.plantilla")
@section("titulo")
Segettm - Contactanos
@endsection
@section("menu")
<li><a href="{{ route("inicio") }}">Inicio</a></li>
          <li><a href="{{ route("nosotros") }}">Nosotros</a></li>
          <li><a href="{{ route("servicios") }}">Servicios</a></li>
          <li><a href="{{ route("contactanos") }}"  class="active">Contactanos</a></li>
@endsection
@section("pagina")
<main id="main">

    <!-- ======= Breadcrumbs ======= -->
    <div class="breadcrumbs">
      <div class="page-header d-flex align-items-center" style="background-image: url('assets/img/page-header.jpg');">
        <div class="container position-relative">
          <div class="row d-flex justify-content-center">
            <div class="col-lg-6 text-center">
              <h2>Contactanos</h2>
              <p>Nos esmeramos por ser una empresa enfocados en la excelencia, brindando un servicio confiable y seguro, sencillamente porque nuestros clientes son la prioridad.</p>
            </div>
          </div>
        </div>
      </div>
      <nav>
        <div class="container">
          <ol>
            <li><a href="{{ route("inicio") }}">Inicio</a></li>
            <li>Contactanos</li>
          </ol>
        </div>
      </nav>
    </div><!-- End Breadcrumbs -->

    <!-- ======= Contact Section ======= -->
    <section id="contact" class="contact">
      <div class="container" data-aos="fade-up">

        <div>
          <iframe style="border:0; width: 100%; height: 340px;"
          src="https://www.google.com/maps/d/u/0/embed?mid=1JJNTMQzrJVh7s39t4WcCdkt0XGPs3Lg&ehbc=2E312F&noprof=1" frameborder="0" allowfullscreen></iframe>
        </div><!-- End Google Maps -->

        <div class="row gy-4 mt-4">

          <div class="col-lg-4">

            <div class="info-item d-flex">
              <i class="bi bi-geo-alt flex-shrink-0"></i>
              <div>
                <h4>Ubicación:</h4>
                <p>Calle Brasil, Casa nro. S/N, urb. Eleazar López Contreras, Ciudad Ojeda, Zulia</p>
              </div>
            </div><!-- End Info Item -->

            <div class="info-item d-flex">
              <i class="bi bi-envelope flex-shrink-0"></i>
              <div>
                <h4>E-mail:</h4>
                <p>info@segettm.com</p>
              </div>
            </div><!-- End Info Item -->

            <div class="info-item d-flex">
              <i class="bi bi-phone flex-shrink-0"></i>
              <div>
                <h4>Teléfono:</h4>
                <p>+58434 3655555</p>
              </div>
            </div><!-- End Info Item -->

          </div>

          <div class="col-lg-8">
            <form method="POST" action="{{ route('formContacto') }}" role="form" class="php-email-form">
                @csrf
              <div class="row">
                <div class="col-md-6 form-group">
                  <input type="text" name="name" class="form-control" id="name" placeholder="Tu nombre" required>
                  {!! $errors->first('name','<p style="color:red;">* :message</p>') !!}
                </div>
                <div class="col-md-6 form-group mt-3 mt-md-0">
                  <input type="email" class="form-control" name="email" id="email" placeholder="Tu E-mail" required>
                  {!! $errors->first('email','<p style="color:red;">* :message</p>') !!}
                </div>
              </div>
              <div class="form-group mt-3">
                <input type="text" class="form-control" name="subject" id="subject" placeholder="Asunto" required>
                {!! $errors->first('subject','<p style="color:red;">* :message</p>') !!}
              </div>
              <div class="form-group mt-3">
                <textarea class="form-control" name="message" rows="5" placeholder="Mensaje" required></textarea>
                {!! $errors->first('message','<p style="color:red;">* :message</p>') !!}
              </div>

                    <div class="my-3">

                        <div class="sent-message">Tu mensaje fue enviado. Gracias!</div>

                    </div>
                    <div class="g-recaptcha" data-sitekey="6Leg9IMpAAAAAMDpx4bBbU7j0rkGyj6kKddre7iW"></div>
              <div class="text-center"><button type="submit">Enviar Mensaje</button></div>
            </form>
          </div><!-- End Contact Form -->

        </div>

      </div>
    </section><!-- End Contact Section -->

  </main><!-- End #main -->

@endsection
