@extends("layaout.plantilla")
@section("titulo")
Segettm - Inicio
@endsection
@section("menu")
<li><a href="{{ route("inicio") }}" class="active">Inicio</a></li>
          <li><a href="{{ route("nosotros") }}">Nosotros</a></li>
          <li><a href="{{ route("servicios") }}">Servicios</a></li>
          <li><a href="{{ route("contactanos") }}">Contactanos</a></li>
@endsection
@section("pagina")
  <!-- ======= Hero Section ======= -->
  <section id="hero" class="hero d-flex align-items-center">
    <div class="container">
      <div class="row gy-4 d-flex justify-content-between">
        <div class="col-lg-6 order-2 order-lg-1 d-flex flex-column justify-content-center">
          <h2 data-aos="fade-up">SEGETTM</h2>
          <p data-aos="fade-up" data-aos-delay="100">El mejor aliado para tu negocio.</p>

          <div class="row gy-4" data-aos="fade-up" data-aos-delay="400">

            <div class="col-lg-3 col-6">
              <div class="stats-item text-center w-100 h-100">
                <span data-purecounter-start="0" data-purecounter-end="232" data-purecounter-duration="1" class="purecounter"></span>
                <p>Clientes</p>
              </div>
            </div><!-- End Stats Item -->

            <div class="col-lg-3 col-6">
              <div class="stats-item text-center w-100 h-100">
                <span data-purecounter-start="0" data-purecounter-end="1321" data-purecounter-duration="1" class="purecounter"></span>
                <p>Traslados Terrestres</p>
              </div>
            </div><!-- End Stats Item -->

            <div class="col-lg-3 col-6">
              <div class="stats-item text-center w-100 h-100">
                <span data-purecounter-start="0" data-purecounter-end="1453" data-purecounter-duration="1" class="purecounter"></span>
                <p>Traslados Maritimos</p>
              </div>
            </div><!-- End Stats Item -->

            <div class="col-lg-3 col-6">
              <div class="stats-item text-center w-100 h-100">
                <span data-purecounter-start="0" data-purecounter-end="32" data-purecounter-duration="1" class="purecounter"></span>
                <p>Trabajadores</p>
              </div>
            </div><!-- End Stats Item -->

          </div>
        </div>

        <div class="col-lg-5 order-1 order-lg-2 hero-img" data-aos="zoom-out">
          <img src="{{ asset("assets/img/banner-inicio.png") }}" class="img-fluid mb-3 mb-lg-0" alt="">
        </div>

      </div>
    </div>
  </section><!-- End Hero Section -->

  <main id="main">

    <!-- ======= Featured Services Section ======= -->
    <section id="featured-services" class="featured-services">
      <div class="container">

        <div class="row gy-4">

            <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up">
                <div class="icon flex-shrink-0"><i class="fa-solid fa-truck"></i></div>
                <div>
                  <h4 class="title">Traslados Terrestres</h4>
                  <p class="description">Brindamos servicios de traslados terrestres para personal, carga liviana y carga pesada para tu empresa</p>
                </div>
              </div>
              <!-- End Service Item -->

              <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up" data-aos-delay="100">
                <div class="icon flex-shrink-0"><i class="fa-solid fa-ship"></i></div>
                <div>
                  <h4 class="title">Traslados Marítimos</h4>
                  <p class="description">Prestamos servicios de transporte para personal con nuestra flota de botes</p>

                </div>
              </div><!-- End Service Item -->

              <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up" data-aos-delay="200">
                <div class="icon flex-shrink-0"><i class="fa-solid fa-truck-ramp-box"></i></div>
                <div>
                  <h4 class="title">Servicios</h4>
                  <p class="description">Te proveemos servicios para traslados de urgencias médicas y buceo industrial</p>

                </div>
              </div><!-- End Service Item -->

        </div>

      </div>
    </section><!-- End Featured Services Section -->

    <!-- ======= About Us Section ======= -->
    <section id="about" class="about pt-0">
      <div class="container" data-aos="fade-up">

        <div class="row gy-4">
          <div class="col-lg-6 position-relative align-self-start order-lg-last order-first">
            <img src="assets/img/about.jpg" class="img-fluid" alt="">
            <a href="https://www.youtube.com/watch?v=LXb3EKWsInQ" class="glightbox play-btn"></a>
          </div>
          <div class="col-lg-6 content order-last  order-lg-first">
            <h3>¿Quienes somos?</h3>
            <p>
                Somos una empresa que nace en la Costa Oriental del Lago de la
                región zuliana, basada en la experiencia de nuestro fundador, quien cuenta con más
                de 30 años en la industria petrolera y petroquímica nacional.
            </p>
            <ul>
              <li data-aos="fade-up" data-aos-delay="100">
                <i class="bi bi-check2-circle"></i>
                <div>
                  <h5>Calidad del servicio</h5>
                  <p>Ofrecemos un servicio de excelencia para garantizar la satisfacción de nuestros clientes</p>
                </div>
              </li>
              <li data-aos="fade-up" data-aos-delay="200">
                <i class="bi bi-fullscreen-exit"></i>
                <div>
                  <h5>Compromiso</h5>
                  <p>Nos aseguramos de realízar seguimiento en la ejecución de nuestros servicios.</p>
                </div>
              </li>
              <li data-aos="fade-up" data-aos-delay="300">
                <i class="bi bi-broadcast"></i>
                <div>
                  <h5>Atención inmediata</h5>
                  <p>Nos esmeramos en brindar soluciones y una respuesta inmediata a nuestros clientes.</p>
                </div>
              </li>
            </ul>
          </div>
        </div>

      </div>
    </section><!-- End About Us Section -->

    <!-- ======= Services Section ======= -->
    <section id="service" class="services pt-0">
      <div class="container" data-aos="fade-up">

        <div class="section-header">
          <span>Nuestros Servicios</span>
          <h2>Nuestros Servicios</h2>

        </div>

        <div class="row gy-4">

          <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
            <div class="card">
              <div class="card-img">
                <img src="assets/img/transporte-personal.png" alt="" class="img-fluid">
              </div>
              <h3><a href="#" class="stretched-link">Transporte de Personal Terrestre</a></h3>
              <!--<p>Cumque eos in qui numquam. Aut aspernatur perferendis sed atque quia voluptas quisquam repellendus temporibus itaqueofficiis odit</p>-->
            </div>
          </div><!-- End Card Item -->

          <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
            <div class="card">
              <div class="card-img">
                <img src="assets/img/transporte-lacustre.png" alt="" class="img-fluid">
              </div>
              <h3><a href="#" class="stretched-link">Transporte de Personal Lacustre</a></h3>
            </div>
          </div><!-- End Card Item -->

          <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="600">
            <div class="card">
              <div class="card-img">
                <img src="assets/img/buceo.png" alt="" class="img-fluid">
              </div>
              <h3><a href="#" class="stretched-link">Servicio de Buceo Industrial</a></h3>
            </div>
          </div><!-- End Card Item -->

          <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
            <div class="card">
              <div class="card-img">
                <img src="assets/img/transporte-liviano.png" alt="" class="img-fluid">
              </div>
              <h3><a href="#" class="stretched-link">Transporte de Carga Liviana</a></h3>
            </div>
          </div><!-- End Card Item -->

          <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="400">
            <div class="card">
              <div class="card-img">
                <img src="assets/img/transporte-pesado.png" alt="" class="img-fluid">
              </div>
              <h3><a href="#" class="stretched-link">Transporte de Carga Pesada</a></h3>
            </div>
          </div><!-- End Card Item -->

          <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="500">
            <div class="card">
              <div class="card-img">
                <img src="assets/img/urgencia-medica.png" alt="" class="img-fluid">
              </div>
              <h3><a href="#" class="stretched-link">Traslado de Urgencias Médicas</a></h3>
            </div>
          </div><!-- End Card Item -->



        </div>

      </div>
    </section><!-- End Services Section -->



    <!-- ======= Features Section ======= -->
    <section id="features" class="features">
      <div class="container " data-aos="fade-up">
        <div class="section-header">
            <span>Valores Corporativos</span>
            <h2>Valores Corporativos</h2>

          </div>
        <div class="row gy-4 align-items-center features-item" data-aos="fade-up">

          <div class="col-md-5">
            <img src="assets/img/responsabilidad.png" class="img-fluid" alt="">
          </div>
          <div class="col-md-7">
            <h3>1.	Responsabilidad</h3>
            <p class="fst-italic">
                Somos fieles cumplidores de nuestras obligaciones.
            </p>
            <p>
                Nos enfocamos en
                brindar soluciones y una repuesta inmediata a
                nuestros clientes.

            </p>
          </div>
        </div><!-- Features Item -->

        <div class="row gy-4 align-items-center features-item" data-aos="fade-up">
          <div class="col-md-5 order-1 order-md-2">
            <img src="assets/img/compromiso.png" class="img-fluid" alt="">
          </div>
          <div class="col-md-7 order-2 order-md-1">
            <h3>2.	Compromiso</h3>
            <p class="fst-italic">
                Aplicado en el cumplimiento de nuestros servicios.
            </p>
            <p>
                En SEGETTM nos esmeramos por ser
                una empresa enfocados en la excelencia,
                brindando un servicio confiable y seguro,
                sencillamente porque nuestros clientes
                son la prioridad.
            </p>
          </div>
        </div><!-- Features Item -->

        <div class="row gy-4 align-items-center features-item" data-aos="fade-up">
          <div class="col-md-5">
            <img src="assets/img/dedicacion.png" class="img-fluid" alt="">
          </div>
          <div class="col-md-7">
            <h3>3.	Dedicación</h3>
            <p  class="fst-italic">Nos esforzamos en brindar a nuestros clientes el mejor servicio.</p>
            <p>
                La calidad es un objetivo permanente en todos los servicios llevados a cabo en la organización, con el propósito de asegurar la satisfacción, atención oportuna, servicio confiable, seguro y con la disposición de un personal competente
            </p>
          </div>
        </div><!-- Features Item -->

        <div class="row gy-4 align-items-center features-item" data-aos="fade-up">
          <div class="col-md-5 order-1 order-md-2">
            <img src="assets/img/features-4.jpg" class="img-fluid" alt="">
          </div>
          <div class="col-md-7 order-2 order-md-1">
            <h3>4.	Perseverancia</h3>
            <p class="fst-italic">
                Nos mantenemos insistiendo en nuestro propósito.
            </p>
            <p>
                Actualmente SEGETTM, C.A. cuenta con 6 años de experiencia en el mercado
                nacional, prestándole sus servicios a empresas del sector público y privado
                venezolano
            </p>
          </div>
        </div><!-- Features Item -->

        <div class="row gy-4 align-items-center features-item" data-aos="fade-up">
            <div class="col-md-5">
              <img src="assets/img/optimismo.png" class="img-fluid" alt="">
            </div>
            <div class="col-md-7">
                <h3>5.  Optimismo</h3>
                <p class="fst-italic">
                  Mantenemos una actitud positiva en nuestro día a día.
                </p>
                <p>
                  Garantizando la operación, el cumplimiento con los requisitos, necesidades y expectativas de nuestros clientes y partes interesadas, con una dirección estratégica que contempla el análisis permanente del contexto y compromiso con la mejora continua del Sistema de Gestión de Calidad.
                </p>
            </div>
          </div><!-- Features Item -->


      </div>
    </section><!-- End Features Section -->

 <!-- ======= Call To Action Section ======= -->
    <section id="call-to-action" class="call-to-action">
      <div class="container" data-aos="zoom-out">

        <div class="row justify-content-center">
          <div class="col-lg-8 text-center">
            <h3>Contactanos</h3>
            <p> Nos esmeramos por ser
                una empresa enfocados en la excelencia,
                brindando un servicio confiable y seguro,
                sencillamente porque nuestros clientes
                son la prioridad.</p>
            <a class="cta-btn" href={{ route("contactanos") }}">Contactanos</a>
          </div>
        </div>

      </div>
    </section><!-- End Call To Action Section -->


  </main><!-- End #main -->



  <a href="#" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <div id="preloader"></div>
@endsection
