@extends("layaout.plantilla")
@section("titulo")
Segettm - Servicios
@endsection
@section("menu")
<li><a href="{{ route("inicio") }}">Inicio</a></li>
          <li><a href="{{ route("nosotros") }}">Nosotros</a></li>
          <li><a href="{{ route("servicios") }}" class="active">Servicios</a></li>
          <li><a href="{{ route("contactanos") }}">Contactanos</a></li>
@endsection
@section("pagina")
<main id="main">

    <!-- ======= Breadcrumbs ======= -->
    <div class="breadcrumbs">
      <div class="page-header d-flex align-items-center" style="background-image: url('assets/img/page-header.jpg');">
        <div class="container position-relative">
          <div class="row d-flex justify-content-center">
            <div class="col-lg-6 text-center">
              <h2>Servicios</h2>
              <p>En SEGETTM, C.A, nos sentimos fielmente
                comprometidos con el crecimiento de la economía y la
                producción nacional, por lo que proporcionamos un
                servicio oportuno y eficiente.</p>
            </div>
          </div>
        </div>
      </div>
      <nav>
        <div class="container">
          <ol>
            <li><a href="{{ route("inicio") }}">Inicio</a></li>
            <li>Servicios</li>
          </ol>
        </div>
      </nav>
    </div><!-- End Breadcrumbs -->

    <!-- ======= Featured Services Section ======= -->
    <section id="featured-services" class="featured-services">
        <div class="container">

          <div class="row gy-4">

            <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up">
              <div class="icon flex-shrink-0"><i class="fa-solid fa-truck"></i></div>
              <div>
                <h4 class="title">Traslados Terrestres</h4>
                <p class="description">Brindamos servicios de traslados terrestres para personal, carga liviana y carga pesada para tu empresa</p>
              </div>
            </div>
            <!-- End Service Item -->

            <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up" data-aos-delay="100">
              <div class="icon flex-shrink-0"><i class="fa-solid fa-ship"></i></div>
              <div>
                <h4 class="title">Traslados Marítimos</h4>
                <p class="description">Prestamos servicios de transporte para personal con nuestra flota de botes</p>

              </div>
            </div><!-- End Service Item -->

            <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up" data-aos-delay="200">
              <div class="icon flex-shrink-0"><i class="fa-solid fa-truck-ramp-box"></i></div>
              <div>
                <h4 class="title">Servicios</h4>
                <p class="description">Te proveemos servicios para traslados de urgencias médicas y buceo industrial</p>

              </div>
            </div><!-- End Service Item -->

          </div>

        </div>
      </section><!-- End Featured Services Section -->



    <!-- ======= Services Section ======= -->
    <section id="service" class="services pt-0">
        <div class="container" data-aos="fade-up">

          <div class="section-header">
            <span>Nuestros Servicios</span>
            <h2>Nuestros Servicios</h2>

          </div>

          <div class="row gy-4">

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
              <div class="card">
                <div class="card-img">
                  <img src="assets/img/transporte-personal.png" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Transporte de Personal Terrestre</a></h3>
                <!--<p>Cumque eos in qui numquam. Aut aspernatur perferendis sed atque quia voluptas quisquam repellendus temporibus itaqueofficiis odit</p>-->
              </div>
            </div><!-- End Card Item -->

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
              <div class="card">
                <div class="card-img">
                  <img src="assets/img/transporte-lacustre.png" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Transporte de Personal Lacustre</a></h3>
              </div>
            </div><!-- End Card Item -->

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="600">
              <div class="card">
                <div class="card-img">
                  <img src="assets/img/buceo.png" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Servicio de Buceo Industrial</a></h3>
              </div>
            </div><!-- End Card Item -->

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
              <div class="card">
                <div class="card-img">
                  <img src="assets/img/transporte-liviano.png" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Transporte de Carga Liviana</a></h3>
              </div>
            </div><!-- End Card Item -->

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="400">
              <div class="card">
                <div class="card-img">
                  <img src="assets/img/transporte-pesado.png" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Transporte de Carga Pesada</a></h3>
              </div>
            </div><!-- End Card Item -->

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="500">
              <div class="card">
                <div class="card-img">
                  <img src="assets/img/urgencia-medica.png" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Traslado de Urgencias Médicas</a></h3>
              </div>
            </div><!-- End Card Item -->



          </div>

        </div>
    </section><!-- End Services Section -->




  </main><!-- End #main -->
@endsection
