@extends("layaout.plantilla")
@section("titulo")
Segettm - Servicios
@endsection
@section("menu")
<li><a href="{{ route("inicio") }}">Inicio</a></li>
          <li><a href="{{ route("nosotros") }}">Nosotros</a></li>
          <li><a href="{{ route("servicios") }}" class="active">Servicios</a></li>
          <li><a href="{{ route("calidad") }}">Calidad</a></li>
          <li><a href="{{ route("contactanos") }}">Contactanos</a></li>
@endsection
@section("pagina")
<main id="main">

    <!-- ======= Breadcrumbs ======= -->
    <div class="breadcrumbs">
      <div class="page-header d-flex align-items-center" style="background-image: url('assets/img/page-header.jpg');">
        <div class="container position-relative">
          <div class="row d-flex justify-content-center">
            <div class="col-lg-6 text-center">
              <h2>Servicios</h2>
              <p>En SEGETTM, C.A, nos sentimos fielmente
                comprometidos con el crecimiento de la economía y la
                producción nacional, por lo que proporcionamos un
                servicio oportuno y eficiente.</p>
            </div>
          </div>
        </div>
      </div>
      <nav>
        <div class="container">
          <ol>
            <li><a href="{{ route("inicio") }}">Inicio</a></li>
            <li>Servicios</li>
          </ol>
        </div>
      </nav>
    </div><!-- End Breadcrumbs -->

    <!-- ======= Featured Services Section ======= -->
    <<!-- ======= Featured Services Section ======= -->
    <section id="featured-services" class="featured-services">
        <div class="container">

          <div class="row gy-4">

              <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up">
                  <div class="icon flex-shrink-0"><i class="fa-solid fa-truck"></i></div>
                  <div>
                    <h4 class="title">Traslados Terrestres</h4>
                    <p class="description">• Transporte de
                      Personal<br>
                      • Transporte de Carga
                      liviana y pesada<br>
                      • Urgencias Médicas</p>
                  </div>
                </div>
                <!-- End Service Item -->

                <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up" data-aos-delay="100">
                  <div class="icon flex-shrink-0"><i class="fa-solid fa-ship"></i></div>
                  <div>
                    <h4 class="title">Traslados Marítimos</h4>
                    <p class="description">• Transporte Marítimo
                      de personal y de
                      carga<br>
                      • Tendido de Líneas.<br>
                      • Buceo Industrial</p>

                  </div>
                </div><!-- End Service Item -->

                <div class="col-lg-4 col-md-6 service-item d-flex" data-aos="fade-up" data-aos-delay="200">
                  <div class="icon flex-shrink-0"><i class="fa-solid fa-truck-ramp-box"></i></div>
                  <div>
                    <h4 class="title">Servicios</h4>
                    <p class="description">• Construcción y
                      mantenimiento de
                      estructuras costa
                      afuera.</p>

                  </div>
                </div><!-- End Service Item -->

          </div>

        </div>
      </section><!-- End Featured Services Section -->
  <!-- End Featured Services Section -->



    <!-- ======= Services Section ======= -->
    <section id="service" class="services pt-0">
        <div class="container" data-aos="fade-up">

          <div class="section-header">
            <span>Nuestros Servicios</span>
            <h2>Nuestros Servicios</h2>

          </div>

          <div class="row gy-4">

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
              <div class="card">
                <div class="card-img">
                  <img src="{{ asset('assets/img/transporte-personal.png')}}" alt="" class="img-fluid">
                </div>
                <h3><a href="#" class="stretched-link">Transporte de Personal Terrestre</a></h3>
                <p>Contamos con una flota variada en capacidades, brindando a nuestros clientes un servicio confiable y seguro.</p>
              </div>
            </div><!-- End Card Item -->

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="400">
                <div class="card">
                  <div class="card-img">
                    <img src="{{ asset('assets/img/transporte-pesado.png')}}" alt="" class="img-fluid">
                  </div>
                  <h3><a href="#" class="stretched-link">Transporte de Carga Pesada y Liviana</a></h3>
                  <p>Realizamos traslados de cargas en todo el territorio nacional, asegurando que la carga llegue segura en los lapsos de tiempo establecidos en las condiciones prometidas.</p>
                </div>
              </div><!-- End Card Item -->

              <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="500">
                <div class="card">
                  <div class="card-img">
                    <img src="{{ asset('assets/img/urgencia-medica.png')}}" alt="" class="img-fluid">
                  </div>
                  <h3><a href="#" class="stretched-link">Traslado de Urgencias Médicas</a></h3>
                  <p>Disponemos de equipos y personal especializado para brindar asistencia médica inmediata a clientes e interesados en áreas industriales.</p>
                </div>
              </div><!-- End Card Item -->


            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
                <div class="card">
                  <div class="card-img">
                    <img src="{{ asset('assets/img/transporte-lacustre.png')}}" alt="" class="img-fluid">
                  </div>
                  <h3><a href="#" class="stretched-link">Transporte Marítimo de personal y de carga</a></h3>
                  <p>Segettm, C.A. Cuenta con una amplia trayectoria en logística y movilización de personal en el lago de Maracaibo, ofreciendo lanchas equipadas, generando confiabilidad en sus traslados.</p>
                </div>
              </div><!-- End Card Item -->

            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
                <div class="card">
                  <div class="card-img">
                    <img src="{{ asset('assets/img/tendido-linea.png')}}" alt="" class="img-fluid">
                  </div>
                  <h3><a href="#" class="stretched-link">Tendido de líneas y cables submarinos</a></h3>
                  <p>Dentro de nuestra experiencia contamos con una amplia trayectoria en reparación y tendido de líneas y
                    cables submarinos en las costas venezolanas, siendo participes en proyectos de gran
                    envergadura a nivel nacional.</p>
                </div>
              </div><!-- End Card Item -->

              <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="600">
                <div class="card">
                  <div class="card-img">
                    <img src="{{ asset('assets/img/buceo.png')}}" alt="" class="img-fluid">
                  </div>
                  <h3><a href="#" class="stretched-link">Servicio de Buceo Industrial</a></h3>
                  <p>Nuestra empresa posee una vasta experiencia en actividades submarinas en el Lago de Maracaibo y toda la geografía venezolana.</p>
                </div>
              </div><!-- End Card Item -->

          </div>

        </div>
    </section><!-- End Services Section -->




  </main><!-- End #main -->
@endsection
